/*
 * Copyright (C) 2000 Robert Fitzsimons
 */

#include "types.h"
#include "unicode.h"
#include "class.h"
#include "classcode.h"
#include "classdata.h"
#include "util.h"

kuint clinit_name_handle;
kuint clinit_descriptor_handle;

void init_class() {
	clinit_name_handle = unicode_put_ascii("<clinit>");
	clinit_descriptor_handle = unicode_put_ascii("()V");
}

Class* class_lookup(Environment* env, kuint class_handle) {
	Class* class = knull;

	class = hashmap_get(env->class_map, class_handle);

	return class;
}

Class* class_find(Environment* env, kuint class_handle) {
	Class* class = knull;
	ClassData* classdata = knull;
	kuint method_index = 0;
	kuint index = 0;

	class = class_lookup(env, class_handle);

	if(class != knull) {
		return class;
	}

	classdata = classdata_find(env, class_handle);

	if(classdata == knull) {
		print_ascii("*** Error loading class ");
		print_unicode(class_handle);
		print_ascii(" ***\n");
		return knull;
	}

	class = memory_allocate(1, ((sizeof(Class) + classdata->static_field_length) + (classdata->constant_data_count * sizeof(kuint))));
	class->constant = (void*)((kuint)class + sizeof(Class) + classdata->static_field_length);
	class->classdata = classdata;
	class->class_handle = class_handle;
	class->method = classdata->method;
	class->field = classdata->field;

	hashmap_put(env->class_map, class->class_handle, class);

	if(classdata->constant_data_count > 0) {
		for(index = 0; index < classdata->constant_data_count; index++) {
			switch(classdata->constant_data[index].class.tag) {
				case CONSTANT_Class:
					class->constant[index] = 0xFFF00000 + index;
					break;
				case CONSTANT_FieldReference:
					class->constant[index] = 0xFFF10000 + index;
					break;
				case CONSTANT_MethodReference:
					class->constant[index] = 0xFFF20000 + index;
					break;
			}
		}
	}

	method_index = find_methoddata_index(class->classdata, clinit_name_handle, clinit_descriptor_handle);
	if(method_index != -1) {
		MethodData* md = class->classdata->method_data[method_index];
		invoke_method(env, md->code, class);
	}

	print_ascii("Loaded class ");
	print_unicode(class_handle);
	print_ascii(" (");
	print_u4(class_handle);
	print_ascii(", 0x");
	print_u4((kuint)class);
	print_ascii(")\n");

	return class;
}

Object* object_create(Environment* env, Class* class) {
	Object* object = knull;

	object = memory_allocate(1, (sizeof(Object) + class->classdata->instance_field_length));
	object->class = class;

	print_ascii("Created object ");
	print_unicode(object->class->class_handle);
	print_ascii(" (0x");
	print_u4((kuint)object);
	print_ascii(")\n");

	return object;
}

Class* resolve_class(Environment* env, Class* caller_class, kuint constant_index) {
	Class* class = (void*)caller_class->constant[constant_index];

	if((kuint)class >= 0xFFF00000) {
		kuint c_index = ((kuint)class & ~0xFFF00000);
		ConstantData* cd = &caller_class->classdata->constant_data[c_index];

		class = class_find(env, cd->class.class_handle);

		if(class != knull) {
			kuint index = 0;
			kuint r_index = 0;

			caller_class->constant[constant_index] = (kuint)class;

			for(index = 0; index < caller_class->classdata->constant_data_count; index++) {
				r_index = caller_class->constant[index];
				cd = &caller_class->classdata->constant_data[index];

				if(cd->ref.class_index != c_index) {
					continue;
				}

				if((cd->ref.tag == CONSTANT_MethodReference) && (r_index >= 0xFFF20000) && (r_index < 0xFFF30000)) {
					r_index = find_methoddata_index(class->classdata, cd->ref.name_handle, cd->ref.descriptor_handle);
				} else if((cd->ref.tag == CONSTANT_FieldReference) && (r_index >= 0xFFF10000) && (r_index < 0xFFF20000)) {
					r_index = find_fielddata_index(class->classdata, cd->ref.name_handle, cd->ref.descriptor_handle);
				} else {
					abort();
				}

				if(r_index != -1) {
					caller_class->constant[index] = r_index;
				} else {
					abort();
				}
			}
		} else {
			abort();
		}
	}

	return class;
}

