/*
 * Copyright (C) 2000 Robert Fitzsimons
 */

#include "types.h"
#include "hashmap.h"
#include "util.h"

typedef struct Entry Entry;

struct HashMap {
	Entry* top;
};

struct Entry {
	Entry* next;
	kuint key;
	void* value;
};

HashMap* hashmap_create() {
	HashMap* map = knull;

	map = memory_allocate(1, sizeof(HashMap));

	return map;
}

void* hashmap_put(HashMap* map, kuint key, void* value) {
	Entry* e = map->top;

	while(e != knull) {
		if(e->key == key) {
			return e->value;
		}
		e = e->next;
	}

	e = memory_allocate(1, sizeof(Entry));
	e->next = map->top;
	e->key = key;
	e->value = value;
	map->top = e;

	return value;
}

void* hashmap_get(HashMap* map, kuint key) {
	Entry* e = map->top;

	while(e != knull) {
		if(e->key == key) {
			return e->value;
		}
		e = e->next;
	}

	return knull;
}

