/*
 * Copyright (C) 2000 Robert Fitzsimons
 */

#ifndef _class_h
#define _class_h

typedef struct Object Object;
typedef struct Class Class;
typedef struct Array Array;

#include "types.h"
#include "environment.h"
#include "classdata.h"

struct Object {
	Class* class;
	kuint flags;
	kuint8 data[0];
};

struct Class {
	ClassData* classdata;
	kuint class_handle;
	Object* class_object;
	kuint* method;
	kuint* field;
	kuint* constant;
	kuint8 data[0];
};

struct Array {
	kuint length;
	kuint8 data[0];
};

Class* class_lookup(Environment* env, kuint class_handle);
Class* class_find(Environment* env, kuint class_handle);

Object* object_create(Environment* env, Class* class);
Class* resolve_class(Environment* env, Class* caller_class, kuint constant_index);

#endif /* _class_h */

