/*
 * Copyright (C) 2000 Robert Fitzsimons
 */

#ifndef _classcode_h
#define _classcode_h

#include "types.h"
#include "environment.h"
#include "classdata.h"
#include "classinfo.h"

kuint64 invoke_method(Environment* env, void* method_code, Class* class, ...);
void bytecode_to_nativecode(Environment* env, ClassInfo* classinfo, ClassData* classdata, MethodData* methoddata);

#define environment_offset 0x00000008
#define class_offset 0x00000010

enum {
	OPCODE_nop = 0x00,
	OPCODE_aconst_null,
	OPCODE_iconst_m1,
	OPCODE_iconst_0,
	OPCODE_iconst_1,
	OPCODE_iconst_2,
	OPCODE_iconst_3,
	OPCODE_iconst_4,
	OPCODE_iconst_5,
	OPCODE_lconst_0,
	OPCODE_lconst_1,
	OPCODE_fconst_0,
	OPCODE_fconst_1,
	OPCODE_fconst_2,
	OPCODE_dconst_0,
	OPCODE_dconst_1,
	OPCODE_bipush,
	OPCODE_sipush,
	OPCODE_ldc,
	OPCODE_ldc_w,
	OPCODE_ldc2_w,
	OPCODE_iload,
	OPCODE_lload,
	OPCODE_fload,
	OPCODE_dload,
	OPCODE_aload,
	OPCODE_iload_0,
	OPCODE_iload_1,
	OPCODE_iload_2,
	OPCODE_iload_3,
	OPCODE_lload_0,
	OPCODE_lload_1,
	OPCODE_lload_2,
	OPCODE_lload_3,
	OPCODE_fload_0,
	OPCODE_fload_1,
	OPCODE_fload_2,
	OPCODE_fload_3,
	OPCODE_dload_0,
	OPCODE_dload_1,
	OPCODE_dload_2,
	OPCODE_dload_3,
	OPCODE_aload_0,
	OPCODE_aload_1,
	OPCODE_aload_2,
	OPCODE_aload_3,
	OPCODE_iaload,
	OPCODE_laload,
	OPCODE_faload,
	OPCODE_daload,
	OPCODE_aaload,
	OPCODE_baload,
	OPCODE_caload,
	OPCODE_saload,
	OPCODE_istore,
	OPCODE_lstore,
	OPCODE_fstore,
	OPCODE_dstore,
	OPCODE_astore,
	OPCODE_istore_0,
	OPCODE_istore_1,
	OPCODE_istore_2,
	OPCODE_istore_3,
	OPCODE_lstore_0,
	OPCODE_lstore_1,
	OPCODE_lstore_2,
	OPCODE_lstore_3,
	OPCODE_fstore_0,
	OPCODE_fstore_1,
	OPCODE_fstore_2,
	OPCODE_fstore_3,
	OPCODE_dstore_0,
	OPCODE_dstore_1,
	OPCODE_dstore_2,
	OPCODE_dstore_3,
	OPCODE_astore_0,
	OPCODE_astore_1,
	OPCODE_astore_2,
	OPCODE_astore_3,
	OPCODE_iastore,
	OPCODE_lastore,
	OPCODE_fastore,
	OPCODE_dastore,
	OPCODE_aastore,
	OPCODE_bastore,
	OPCODE_castore,
	OPCODE_sastore,
	OPCODE_pop,
	OPCODE_pop2,
	OPCODE_dup,
	OPCODE_dup_x1,
	OPCODE_dup_x2,
	OPCODE_dup2,
	OPCODE_dup2_x1,
	OPCODE_dup2_x2,
	OPCODE_swap,
	OPCODE_iadd,
	OPCODE_ladd,
	OPCODE_fadd,
	OPCODE_dadd,
	OPCODE_isub,
	OPCODE_lsub,
	OPCODE_fsub,
	OPCODE_dsub,
	OPCODE_imul,
	OPCODE_lmul,
	OPCODE_fmul,
	OPCODE_dmul,
	OPCODE_idiv,
	OPCODE_ldiv,
	OPCODE_fdiv,
	OPCODE_ddiv,
	OPCODE_irem,
	OPCODE_lrem,
	OPCODE_frem,
	OPCODE_drem,
	OPCODE_ineg,
	OPCODE_lneg,
	OPCODE_fneg,
	OPCODE_dneg,
	OPCODE_ishl,
	OPCODE_lshl,
	OPCODE_ishr,
	OPCODE_lshr,
	OPCODE_iushr,
	OPCODE_lushr,
	OPCODE_iand,
	OPCODE_land,
	OPCODE_ior,
	OPCODE_lor,
	OPCODE_ixor,
	OPCODE_lxor,
	OPCODE_iinc,
	OPCODE_i2l,
	OPCODE_i2f,
	OPCODE_i2d,
	OPCODE_l2i,
	OPCODE_l2f,
	OPCODE_l2d,
	OPCODE_f2i,
	OPCODE_f2l,
	OPCODE_f2d,
	OPCODE_d2i,
	OPCODE_d2l,
	OPCODE_d2f,
	OPCODE_i2b,
	OPCODE_i2c,
	OPCODE_i2s,
	OPCODE_lcmp,
	OPCODE_fcmpl,
	OPCODE_fcmpg,
	OPCODE_dcmpl,
	OPCODE_dcmpg,
	OPCODE_ifeq,
	OPCODE_ifne,
	OPCODE_iflt,
	OPCODE_ifge,
	OPCODE_ifgt,
	OPCODE_ifle,
	OPCODE_if_icmpeq,
	OPCODE_if_icmpne,
	OPCODE_if_icmplt,
	OPCODE_if_icmpge,
	OPCODE_if_icmpgt,
	OPCODE_if_icmple,
	OPCODE_if_acmpeq,
	OPCODE_if_acmpne,
	OPCODE_goto,
	OPCODE_jsr,
	OPCODE_ret,
	OPCODE_tableswitch,
	OPCODE_lookupswitch,
	OPCODE_ireturn,
	OPCODE_lreturn,
	OPCODE_freturn,
	OPCODE_dreturn,
	OPCODE_areturn,
	OPCODE_return,
	OPCODE_getstatic,
	OPCODE_putstatic,
	OPCODE_getfield,
	OPCODE_putfield,
	OPCODE_invokevirtual,
	OPCODE_invokespecial,
	OPCODE_invokestatic,
	OPCODE_invokeinterface,
	OPCODE_xxxunusedxxx,
	OPCODE_new,
	OPCODE_newarray,
	OPCODE_anewarray,
	OPCODE_arraylength,
	OPCODE_athrow,
	OPCODE_checkcast,
	OPCODE_instanceof,
	OPCODE_monitorenter,
	OPCODE_monitorexit,
	OPCODE_wide,
	OPCODE_multianewarray,
	OPCODE_ifnull,
	OPCODE_ifnonnull,
	OPCODE_goto_w,
	OPCODE_jsr_w,
	OPCODE_breakpoint,
	OPCODE_impdep1 = 0xFE,
	OPCODE_impdep2,
};

#endif /* _classcode_h */

