/*
 * Copyright (C) 2000 Robert Fitzsimons
 */

#ifndef _classdata_h
#define _classdata_h

typedef struct ClassData ClassData;
typedef struct InterfaceData InterfaceData;
typedef struct MethodData MethodData;
typedef struct FieldData FieldData;
typedef union ConstantData ConstantData;

#include "types.h"
#include "environment.h"
#include "class.h"
#include "classinfo.h"

struct ClassData {
	kuint name_handle;
	ClassData* superclass;
	kuint flags;
	kuint* method;
	MethodData** method_data;
	kuint method_data_count;
	kuint* field;
	FieldData** field_data;
	kuint field_data_count;
	InterfaceData** interface_data;
	kuint interface_data_count;
	ConstantData* constant_data;
	kuint constant_data_count;
	kuint instance_field_length;
	kuint static_field_length;
};

struct MethodData {
	ClassData* classdata;
	kuint name_handle;
	kuint descriptor_handle;
	kuint flags;
	kuint16 max_stack;
	kuint16 max_locals;
	kuint code_length;
	kuint8* code;
};

struct FieldData {
	ClassData* classdata;
	kuint name_handle;
	kuint descriptor_handle;
	kuint flags;
	kuint offset;
};

struct InterfaceData {
	ClassData* classdata;
};

union ConstantData {
	struct {
		kuint tag;
		kuint class_handle;
	} class;
	struct {
		kuint tag;
		kuint class_index;
		kuint name_handle;
		kuint descriptor_handle;
	} ref;
};

#define FLAG_PUBLIC       0x00010000
#define FLAG_PRIVATE      0x00020000
#define FLAG_PROTECTED    0x00040000
#define FLAG_STATIC       0x00080000
#define FLAG_FINAL        0x00100000
#define FLAG_SUPER        0x00200000
#define FLAG_SYNCHRONIZED 0x00200000
#define FLAG_VOLATILE     0x00400000
#define FLAG_TRANSIENT    0x00800000
#define FLAG_NATIVE       0x01000000
#define FLAG_INTERFACE    0x02000000
#define FLAG_ABSTRACT     0x04000000
#define FLAG_STRICT       0x08000000

#define FLAG_ARRAY            0x00001000
#define FLAG_RESOLVED         0x00002000
#define FLAG_SIZE_MASK        0x000000FF
#define FLAG_RETURN_VOID      0x00000100
#define FLAG_RETURN_REFERENCE 0x00000200
#define FLAG_RETURN_VALUE32   0x00000400
#define FLAG_RETURN_VALUE64   0x00000800

ClassData* classdata_lookup(Environment* env, kuint class_handle);
ClassData* classdata_find(Environment* env, kuint class_handle);

kuint find_methoddata_index(ClassData* classdata, kuint name_handle, kuint descriptor_handle);
kuint find_fielddata_index(ClassData* classdata, kuint name_handle, kuint descriptor_handle);

void classdata_free(ClassData* classdata);
void classdata_print(ClassData* classdata);
void classdata_print_methoddata(MethodData* methoddata);

ConstantInfo* constant_resolve(Environment* env, ClassInfo* classinfo, kuint index, kuint keep);
void parse_method_descriptor(kuint descriptor_handle, kuint* flags);
void parse_field_descriptor(kuint descriptor_handle, kuint* flags);

#endif /* _classdata_h */

