/*
 * Copyright (C) 2000 Robert Fitzsimons
 */

#ifndef _classinfo_h
#define _classinfo_h

typedef struct ClassInfo ClassInfo;
typedef union ConstantInfo ConstantInfo;
typedef struct FieldInfo FieldInfo;
typedef struct MethodInfo MethodInfo;
typedef struct AttributeInfo AttributeInfo;

#include "types.h"
#include "unicode.h"

struct ClassInfo {
	kuint status;
	kuint magic;
	kuint minor_version;
	kuint major_version;
	kuint constant_count;
	ConstantInfo* constant;
	kuint access_flags;
	kuint thisclass;
	kuint superclass;
	kuint interface_count;
	kuint* interface;
	kuint field_count;
	FieldInfo* field;
	kuint method_count;
	MethodInfo* method;
	kuint attribute_count;
	AttributeInfo* attribute;
	kuint constant_index;
};

union ConstantInfo {
	struct {
		kuint tag;
		kuint index;
	} info;
	struct {
		kuint tag;
		kuint length;
		kuint8* bytes;
	} utf8_info;
	struct {
		kuint tag;
		kuint name_index;
	} class_info;
	struct {
		kuint tag;
		kuint class_index;
		kuint nametype_index;
	} ref_info;
	struct {
		kuint tag;
		kuint string_index;
	} string_info;
	struct {
		kuint tag;
		kuint32 bytes;
	} v32_info;
	struct {
		kuint tag;
		kuint32 high_bytes;
		kuint32 low_bytes;
	} v64_info;
	struct {
		kuint tag;
		kuint name_index;
		kuint descriptor_index;
	} nametype_info;
	struct {
		kuint tag;
		kuint index;
		kuint hash;
	} unicode;
	struct {
		kuint tag;
		kuint index;
		kuint class_handle;
	} class;
	struct {
		kuint tag;
		kuint index;
		kuint class_index;
		kuint name_handle;
		kuint descriptor_handle;
	} ref;
	struct {
		kuint tag;
		kuint index;
		kuint name_handle;
		kuint descriptor_handle;
	} nametype;
};

struct FieldInfo {
	kuint access_flags;
	kuint name_index;
	kuint descriptor_index;
	kuint attribute_count;
	AttributeInfo* attribute;
};

struct MethodInfo {
	kuint access_flags;
	kuint name_index;
	kuint descriptor_index;
	kuint attribute_count;
	AttributeInfo* attribute;
};

struct AttributeInfo {
	kuint name_index;
	kuint length;
	kuint8* array;
};

#define CONSTANT_Info_Utf8 0x01
#define CONSTANT_Info_Integer 0x03
#define CONSTANT_Info_Float 0x04
#define CONSTANT_Info_Long 0x05
#define CONSTANT_Info_Double 0x06
#define CONSTANT_Info_Class 0x07
#define CONSTANT_Info_String 0x08
#define CONSTANT_Info_FieldRef 0x09
#define CONSTANT_Info_MethodRef 0x0A
#define CONSTANT_Info_InterfaceMethodRef 0x0B
#define CONSTANT_Info_NameAndType 0x0C

#define CONSTANT_Resolved 0x0100
#define CONSTANT_Keep 0x0200
#define CONSTANT_Mask 0x00FF
#define CONSTANT_Unicode 0x0001
#define CONSTANT_Class 0x0002
#define CONSTANT_FieldReference 0x0003
#define CONSTANT_MethodReference 0x0004
#define CONSTANT_NameAndType 0x0005

ClassInfo* classinfo_build(kuint8* buffer, kuint buffer_length);
void classinfo_free(ClassInfo* classinfo);

#endif /* _classinfo_h */

