/*
 * Copyright (C) 2000 Robert Fitzsimons
 */

#ifndef _native_h
#define _native_h

typedef struct NativeMethod NativeMethod;

#include "types.h"
#include "environment.h"

struct NativeMethod {
	NativeMethod* next;
	kuint class_handle;
	kuint name_handle;
	kuint descriptor_handle;
	void* method;
};

void add_native_method(Environment* env, kuint class_handle, kuint name_handle, kuint descriptor_handle, void* method);
void* resolve_native_method(Environment* env, kuint class_handle, kuint name_handle, kuint descriptor_handle);

#endif /* _native_h */

