/*
 * Copyright (C) 2000 Robert Fitzsimons
 */

#ifndef _unicode_h
#define _unicode_h

typedef struct Unicode Unicode;

#include "types.h"

struct Unicode {
	kuint hash;
	kuint length;
	kuint16 array[0];
};

kuint unicode_put(Unicode* unicode);
kuint unicode_put_ascii(kuint8* ascii);
kuint unicode_put_utf8(kuint8* utf8, kuint utf8_length);
kuint unicode_put_u2_array(kuint16* u2, kuint u2_length);

Unicode* unicode_get(kuint hash);
kuint8* unicode_get_ascii(kuint hash);
kuint8* unicode_get_utf8(kuint hash, kuint* utf8_length);

Unicode* ascii_to_unicode(kuint8* ascii);
Unicode* utf8_to_unicode(kuint8* utf8, kuint utf8_length);
kuint8* unicode_to_ascii(Unicode* unicode);
kuint8* unicode_to_utf8(Unicode* unicode, kuint* utf8_length);

kuint unicode_hash(kuint16* u2, kuint u2_length);

#endif /* _unicode_h */

