/*
 * Copyright (C) 2000 Robert Fitzsimons
 */

#ifndef _util_h
#define _util_h

#include "types.h"
#include <stddef.h>
#include <stdio.h>
#include <stdlib.h>

void* memory_allocate(kuint count, kuint size);
void memory_free(void* pointer);
void* memory_copy(void* destination, void* source, kuint length);

kuint8 read_u1(kuint8* buffer, kuint* index);
kuint16 read_u2(kuint8* buffer, kuint* index);
kuint32 read_u4(kuint8* buffer, kuint* index);
kuint8* read_u1_array(kuint8* buffer, kuint* index, kuint length);

void print_u1(kuint value);
void print_u2(kuint value);
void print_u4(kuint value);
void print_u1_array(kuint8* array, kuint length);
void print_u2_array(kuint16* array, kuint length);
void print_ascii(kuint8* ascii);
void print_utf8(kuint8* utf8, kuint utf8_length);
void print_unicode(kuint hash);
void print_sp();
void print_nl();

kuint read_file(kuint8* filename, kuint8** array, kuint* array_length);

#define abort() ({ \
        printf("*** abort %s %d ***\n", __FILE__, __LINE__); \
	fflush(stdin); \
        abort(); \
})

#endif /* _util_h */

