/*
 * Copyright (C) 2000 Robert Fitzsimons
 */

#include "types.h"
#include "environment.h"
#include "class.h"
#include "classcode.h"
#include "classdata.h"
#include "unicode.h"
#include "util.h"

void init_signal();
void init_native();
void init_util();
void init_unicode();
void init_environment();
void init_class();
void init_classcode();
void init_classdata();
void init_classinfo();
void init_main();

void init() {
	init_signal();
	init_util();
	init_unicode();
	init_environment();
	init_class();
	init_classcode();
	init_classdata();
	init_classinfo();
	init_native();
	init_main();
}

kuint main_name_handle;
kuint main_descriptor_handle;

void init_main() {
        main_name_handle = unicode_put_ascii("main");
        main_descriptor_handle = unicode_put_ascii("([Ljava/lang/String;)V");
}

int main(int argc, char** argv) {
	Environment* env = knull;
	Class* class = knull;
	kuint class_handle = 0;
	kuint method_index = 0;

	if(argc != 2) {
		return 1;
	}

	init();

	env = environment_create();

	class_handle = unicode_put_ascii(argv[1]);
	class = class_find(env, class_handle);

	method_index = find_methoddata_index(class->classdata, main_name_handle, main_descriptor_handle);
	if(method_index != -1) {
		MethodData* md = class->classdata->method_data[method_index];
		invoke_method(env, md->code, class, knull);
	}

	print_ascii("End\n");

	return 0;
}

