/*
 * Copyright (C) 2000 Robert Fitzsimons
 */

#include "types.h"
#include "environment.h"
#include "classcode.h"
#include "util.h"
#include "native.h"

void init_native() {
}

void add_native_method(Environment* env, kuint class_handle, kuint name_handle, kuint descriptor_handle, void* method) {
	NativeMethod* nm = knull;

	nm = memory_allocate(1, sizeof(NativeMethod));
	nm->next = env->native_method;
	nm->class_handle = class_handle;
	nm->name_handle = name_handle;
	nm->descriptor_handle = descriptor_handle;
	nm->method = method;
	env->native_method = nm;
}

void* resolve_native_method(Environment* env, kuint class_handle, kuint name_handle, kuint descriptor_handle) {
	NativeMethod* nm = env->native_method;

	printf("??? %08X %08X %08X ???\n", (unsigned int)class_handle, (unsigned int)name_handle, (unsigned int)descriptor_handle);

	while(nm != knull) {
		if(
			(nm->class_handle == class_handle) &&
			(nm->name_handle == name_handle) &&
			(nm->descriptor_handle == descriptor_handle)
		) {
			return nm->method;
		}
		nm = nm->next;
	}

	return knull;
}

