/*
 * Copyright (C) 2000 Robert Fitzsimons
 */

#include "types.h"
#include "util.h"
#include "unicode.h"
#include "environment.h"
#include "class.h"
#include "classcode.h"
#include "native.h"
#include <signal.h>

void signal_handler(int signum, struct sigcontext context);

struct sigaction new_action;
struct sigaction old_action;

void init_signal() {
	new_action.sa_handler = (void*)signal_handler;
	sigaction(SIGSEGV, &new_action, &old_action);
}

void print_context(struct sigcontext* context) {
	kuint* esp = (void*)context->esp;
	kuint index = 0;

	printf("????????\n");
	printf("eip %08X  err %08X  cr2 %08X\n", (unsigned int)context->eip, (unsigned int)context->err, (unsigned int)context->cr2);
	printf("eax %08X  ebx %08X  ecx %08X  edx %08X\n", (unsigned int)context->eax, (unsigned int)context->ebx, (unsigned int)context->ecx, (unsigned int)context->edx);
	printf("edi %08X  esi %08X  esp %08X  ebp %08X\n", (unsigned int)context->edi, (unsigned int)context->esi, (unsigned int)context->esp, (unsigned int)context->ebp);
	for(index = 0; index < 32; index++) {
		kuint mod = index % 8;
		if(mod == 7) {
			printf("%08X\n", (unsigned int)esp[index]);
		} else {
			printf("%08X ", (unsigned int)esp[index]);
		}
	}
	printf("????????\n");
}

void signal_handler(int signum, struct sigcontext context) {
	kuint* ebp = (void*)context.ebp;

	if((context.edx >= 0xFFF00000) && (context.edx < 0xFFF10000)) {
		Environment* env = (void*)ebp[environment_offset / sizeof(kuint)];
		Class* caller_class = (void*)ebp[class_offset / sizeof(kuint)];
		context.edx = (kuint)resolve_class(env, caller_class, (context.edx & ~0xFFF00000));
		return;
	}

	print_context(&context);

	abort();
}

