/*
 * Copyright (C) 2000 Robert Fitzsimons
 */

#include "types.h"
#include "util.h"
#include "unicode.h"
#include <stdio.h>
#include <stdlib.h>

void init_util() {
}

void* memory_allocate(kuint count, kuint size) {
	void* pointer = calloc(count, size);

	if(pointer != knull) {
		return pointer;
	} else {
		abort();
	}
}

void memory_free(void* pointer) {
	free(pointer);
}

void* memory_copy(void* destination, void* source, kuint length) {
	return memcpy(destination, source, length);
}

kuint8 read_u1(kuint8* buffer, kuint* index) {
	return buffer[(*index)++];
}

kuint16 read_u2(kuint8* buffer, kuint* index) {
	kuint value = 0;
	value |= (buffer[(*index)++] << 8);
	value |= (buffer[(*index)++]);
	return value;
}

kuint32 read_u4(kuint8* buffer, kuint* index) {
	kuint value = 0;
	value |= (buffer[(*index)++] << 24);
	value |= (buffer[(*index)++] << 16);
	value |= (buffer[(*index)++] << 8);
	value |= (buffer[(*index)++]);
	return value;
}

kuint8* read_u1_array(kuint8* buffer, kuint* index, kuint length) {
	kuint8* array = memory_allocate(length, sizeof(kuint8));
	memory_copy(array, &buffer[(*index)], (length * sizeof(kuint8)));
	(*index) += (length * sizeof(kuint8));
	return array;
}

void print_u1(kuint value) {
	printf("%02X", (int)value);
}

void print_u2(kuint value) {
	printf("%04X", (int)value);
}

void print_u4(kuint value) {
	printf("%08X", (int)value);
}

void print_u1_array(kuint8* array, kuint length) {
	kuint index = 0;
	while(index < length) {
		printf("%02X", (int)array[index++]);
	}
}

void print_u2_array(kuint16* array, kuint length) {
	kuint index = 0;
	while(index < length) {
		printf("%04X", (int)array[index++]);
	}
}

void print_ascii(kuint8* ascii) {
	printf("%s", ascii);
}

void print_utf8(kuint8* utf8, kuint utf8_length) {
	kuint index = 0;

	while(index < utf8_length) {
		printf("%c", (int)utf8[index++]);
	}
}

void print_unicode(kuint hash) {
	Unicode* unicode = unicode_get(hash);
	kuint index = 0;

	while(index < unicode->length) {
		kuint c = unicode->array[index++];
		if((c >= 0x20) && (c < 0x80)) {
			printf("%c", (int)c);
		} else {
			printf("\\u%04X", (int)c);
		}
	}
}

void print_sp() {
	printf("  ");
}

void print_nl() {
	printf("\n");
}

#define BUFFER_SIZE 2048

kuint read_file(kuint8* filename, kuint8** array, kuint* array_length) {
	FILE* fp = knull;
	kuint8* buffer = knull;
	kuint buffer_length = 0;
	kuint length = 0;
	kuint count = 0;

	(*array) = knull;
	(*array_length) = 0;

	if((fp = fopen(filename, "rb")) == 0) {
		print_ascii("*** cound not open file ");
		print_ascii(filename);
		print_ascii(" ***\n");
		return 1;
	}

	do {
		if((length + (BUFFER_SIZE / 2)) > buffer_length) {
			buffer_length += BUFFER_SIZE;
			(*array) = realloc((*array), buffer_length);
			buffer = &(*array)[length];
		}

		count = fread(buffer, 1, buffer_length - length, fp);

		length += count;
	} while(count > 0);

	(*array_length) = length;

	return 0;
}

